/*
 * AltaPropietari.java
 *
 * Created on 27 de mayo de 2008, 18:42
 */

package actions;

import entitats.Propietari;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionForward;
import org.apache.tools.ant.taskdefs.condition.IsSet;
/**
 *
 * @author dai
 * @version
 */

public class AltaPropietari extends Action {
    
    public ActionForward execute(ActionMapping mapping, ActionForm  form,
            HttpServletRequest request, HttpServletResponse response)
            throws Exception {
        
        DataSource ds = null;
        Connection con = null;
        Propietari propietari = (Propietari) form;
        String tipus;
        
        try{
            ds = this.getDataSource(request);
            con = ds.getConnection();
            Statement st = con.createStatement();
            
            //Si estan els camps nom o cognom i raosocial plens, fa un find forward informant que nomes
            //un camp d'ells pot estar ple per diferenciar si es persona o empresa
            if ((!propietari.getNom().isEmpty() || !propietari.getCognom1().isEmpty() || !propietari.getCognom2().isEmpty()) && !propietari.getRaoSocial().isEmpty() ) {
                propietari.setError("Nomes s'accepta nom i cognoms o b rao social");
                return mapping.findForward("ok");
            }
            
            else {
                
                //Comprova si es un usuari o persona el client q s'introduira
                if (propietari.getRaoSocial().isEmpty()) {
                    tipus = "persona";
                    propietari.setTipus("persona");
                } else {
                    tipus = "empresa";
                    propietari.setTipus("empresa");
                }
                
                //Comprova que les dades obligatories del formulari estan plenes
                if (propietari.comprovaDadesFormulari()) {
                    propietari.setError("Hi han camps obligatoris buits");
                    return mapping.findForward("ok");
                    
                } else {
                    
                    //Fa l'insert a la taula d'entitats
                    st.executeUpdate("INSERT INTO entitats (nif, tipus) VALUES ('"+propietari.getNif()+"', '"+propietari.getTipus()+"')");
                    ResultSet rs1 = st.executeQuery("SELECT last_insert_id()");
                    rs1.next();
                    int idEntitat = rs1.getInt(1);
                    rs1.close();
                    
                    //Inserta la relacio a la taula clients i propietaris
                    st.executeUpdate("INSERT INTO clients (id_entitat) VALUES ("+idEntitat+")");
                    rs1 = st.executeQuery("SELECT last_insert_id()");
                    rs1.next();
                    int idClient = rs1.getInt(1);
                    rs1.close();
                    st.executeUpdate("INSERT INTO propietaris (id_client, actiu) VALUES ("+idClient+", 1)");
                    
                    //Comprova si es persona o empresa i l'introdueix a la taula corresponent
                    if (tipus.equals("persona")) {
                        st.executeUpdate("INSERT INTO persones (id_entitat, nom, cognom1, cognom2) VALUES ("+idEntitat+", '"+propietari.getNom()+"', '"+propietari.getCognom1()+"', '"+propietari.getCognom2()+"')");
                    } else if (tipus.equals("empresa")){
                        st.executeUpdate("INSERT INTO empreses (id_entitat, rao_social) VALUES ("+idEntitat+", '"+propietari.getRaoSocial()+"')");
                    }
                    
                    //Si el telefon no esta buit el fica a la bd
                    if (!propietari.getTelefon().isEmpty()) {
                        st.executeUpdate("INSERT INTO telefons (telefon) VALUES ('"+propietari.getTelefon()+"')");
                        rs1 = st.executeQuery("SELECT last_insert_id()");
                        rs1.next();
                        int idTelefon = rs1.getInt(1);
                        st.executeUpdate("INSERT INTO telefon_entitat (id_telefon, id_entitat) VALUES ("+idEntitat+", "+idTelefon+")");
                    }
                    
                    //Si l'adresa no esta buida la inserta a la bd
                    if (!propietari.getAdresa().isEmpty()){
                        st.executeUpdate("INSERT INTO adreses (id_zona, adresa) VALUES ("+propietari.getZona()+", '"+propietari.getAdresa()+"')");
                        
                        rs1 = st.executeQuery("SELECT last_insert_id()");
                        rs1.next();
                        int idAdresa = rs1.getInt(1);
                        st.executeUpdate("INSERT INTO adresa_entitat (id_adresa, id_entitat) VALUES ("+idAdresa+", "+idEntitat+")");
                    }
                    st.close();
                    propietari.setError("S'ha insertat correctament");
                }
            }
        }catch(Exception excepcio){
            propietari.setError("<font color='red'>Excepcio ocorreguda en acions.AltaPropietari" +
                    "\n"+excepcio.getMessage()+"<font>");
            
        } finally {
            try {
                if (con != null ) {
                    con.close();
                }
            } catch (Exception excepcio){
                propietari.setError("<font color='red'>Excepcio ocorreguda en acions.AltaPropietari" +
                        "\n"+excepcio.getMessage()+"<font>");
                return mapping.findForward("ok");
            }
        }
        return mapping.findForward("ok");
    }
}
